#include "pch.h"
#include "CPcm.h"
#include <stdio.h>
#include "myfunc.h"


// Avrt̃bp[֐`
#include <avrt.h>										// bp[֐ĝœǂݍ܂Ȃ

// Cu
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "Avrt.lib")

// }N
#define SAFE_RELEASE(x)		{ if( x ) { x->Release(); x=NULL; } }
#define SAFE_FREE(x)		{ if( x ) { free(x); x=NULL; } }

// C^[tF[XGUID̎(vWFNgCt@CɕK1Kv)
const CLSID CLSID_MMDeviceEnumerator = __uuidof(MMDeviceEnumerator);
const IID IID_IMMDeviceEnumerator = __uuidof(IMMDeviceEnumerator);
const IID IID_IAudioClient = __uuidof(IAudioClient);
const IID IID_IAudioClock = __uuidof(IAudioClock);
const IID IID_IAudioRenderClient = __uuidof(IAudioRenderClient);

IAudioRenderClient*		g_pRenderClient = NULL;		// _[NCAgC^[tF[X
IAudioClient*					g_pAudioClient = NULL;		// I[fBINCAgC^[tF[X
IMMDevice*						g_pDevice = NULL;
HANDLE							g_hEvent = NULL;		// Cxgnh
HANDLE							m_hThread = NULL;		// Xbhnh
BOOL								m_bThreadLoop = FALSE;	// Xbh
int									m_nFrameSize = 0;		// 1Tṽobt@TCY
int									m_nCurrentIndex = 0;		// WAVt@C̍Đʒu
LPBYTE							g_pbyData = NULL;							// f[^
DWORD							g_dwDataSize = 0;
WAVHEADER					g_WavHeader;
WAVEFORMATEXTENSIBLE g_WavFromat;


LPBYTE GetBuffer(void) { return g_pbyData; }
int GetBufferSize(void) { return g_dwDataSize; }
int GetChannel(void) { return (int)g_WavHeader.wChannel; }
int GetSampleRate(void) { return (int)g_WavHeader.dwSample; }
int GetBitrate(void) { return (int)g_WavHeader.wBitrate; }



// }N
#define SAFE_RELEASE(x)		{ if( x ) { x->Release(); x=NULL; } }
#define SAFE_FREE(x)		{ if( x ) { free(x); x=NULL; } }

void ReleaseInterface()
{
	SAFE_RELEASE(g_pDevice);
	SAFE_RELEASE(g_pRenderClient);
	SAFE_RELEASE(g_pAudioClient);
	CoUninitialize();
}


CPcm::CPcm()
{
	//initWASAPI();
	//m_pFp = NULL;
	g_pbyData = NULL;							// f[^
	g_dwDataSize = 0;
	memset(&g_WavHeader, 0, sizeof(WAVHEADER));
	m_nCurrentIndex = 0;
	ZeroMemory(&g_WavFromat, sizeof(g_WavFromat));
}

CPcm::~CPcm()
{
	if (g_pbyData != NULL)
	{
		delete g_pbyData;
	}
}


BOOL CPcm::GetDefaultDevice()
{
	HRESULT ret;
	IMMDeviceEnumerator* pDeviceEnumerator = NULL;		// }`fBAfoCX񋓃C^[tF[X


	// }`fBAfoCX񋓎q
	ret = CoCreateInstance(CLSID_MMDeviceEnumerator, NULL, CLSCTX_ALL, IID_IMMDeviceEnumerator, (void**)&pDeviceEnumerator);
	if (FAILED(ret)) {
		DEBUG("CLSID_MMDeviceEnumeratorG[\n");
		return FALSE;
	}

	// ftHg̃foCXI
	ret = pDeviceEnumerator->GetDefaultAudioEndpoint(eRender, eConsole, &g_pDevice);
	if (FAILED(ret)) {
		DEBUG("GetDefaultAudioEndpointG[\n");
		return FALSE;
	}
	return TRUE;
}

BOOL CPcm::IsFormat()
{
	HRESULT ret;
	// I[fBINCAg
	ret = g_pDevice->Activate(IID_IAudioClient, CLSCTX_ALL, NULL, (void**)&g_pAudioClient);
	if (FAILED(ret)) {
		return FALSE;
	}
	// tH[}bg̍\z
	ZeroMemory(&g_WavFromat, sizeof(g_WavFromat));
	g_WavFromat.Format.cbSize = sizeof(WAVEFORMATEXTENSIBLE) - sizeof(WAVEFORMATEX);			// = 22
	g_WavFromat.Format.wFormatTag = WAVE_FORMAT_EXTENSIBLE;
	g_WavFromat.Format.nChannels = 2;
	g_WavFromat.Format.nSamplesPerSec = 44100;
	g_WavFromat.Format.wBitsPerSample = 16;
	g_WavFromat.Format.nBlockAlign = g_WavFromat.Format.nChannels * g_WavFromat.Format.wBitsPerSample / 8;
	g_WavFromat.Format.nAvgBytesPerSec = g_WavFromat.Format.nSamplesPerSec * g_WavFromat.Format.nBlockAlign;
	g_WavFromat.Samples.wValidBitsPerSample = g_WavFromat.Format.wBitsPerSample;
	g_WavFromat.dwChannelMask = SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT;
	g_WavFromat.SubFormat = KSDATAFORMAT_SUBTYPE_PCM;

	// 1TṽTCYۑ(16bitXeIȂ4byte)
	m_nFrameSize = g_WavFromat.Format.nBlockAlign;

	// tH[}bg̃T|[g`FbN
	ret = g_pAudioClient->IsFormatSupported(AUDCLNT_SHAREMODE_EXCLUSIVE, (WAVEFORMATEX*)&g_WavFromat, NULL);
	if (FAILED(ret)) {
		return FALSE;
	}
	return true;

}


BOOL CPcm::SetLatency()
{
	HRESULT ret;

	// CeVݒ
	REFERENCE_TIME default_device_period = 0;
	REFERENCE_TIME minimum_device_period = 0;
	int latency = 0;
	if (latency != 0) {
		// w肵CeV(ms)Zbg
		default_device_period = (REFERENCE_TIME)latency * 10000LL;		// ftHgfoCXsIhɃZbg
		TRACE2("CeVw             : %I64d (%f~b)\n", default_device_period, default_device_period / 10000.0);
	}
	else {
		ret = g_pAudioClient->GetDevicePeriod(&default_device_period, &minimum_device_period);
		TRACE2("ftHgfoCXsIh : %I64d (%f~b)\n", default_device_period, default_device_period / 10000.0);
		TRACE2("ŏfoCXsIh       : %I64d (%f~b)\n", minimum_device_period, minimum_device_period / 10000.0);
	}

	// 
	UINT32 frame = 0;
	ret = g_pAudioClient->Initialize(AUDCLNT_SHAREMODE_EXCLUSIVE,
		AUDCLNT_STREAMFLAGS_NOPERSIST | AUDCLNT_STREAMFLAGS_EVENTCALLBACK,
		default_device_period,				// ftHgfoCXsIhlZbg
		default_device_period,				// ftHgfoCXsIhlZbg
		(WAVEFORMATEX*)&g_WavFromat,
		NULL);
	if (FAILED(ret)) {
		if (ret == AUDCLNT_E_BUFFER_SIZE_NOT_ALIGNED) {
			TRACE0("obt@TCYACgG[̂ߏC\n");

			// C̃t[擾
			ret = g_pAudioClient->GetBufferSize(&frame);
			TRACE1("C̃t[         : %d\n", frame);
			default_device_period = (REFERENCE_TIME)(10000.0 *						// (REFERENCE_TIME(100ns) / ms) *
				1000 *						// (ms / s) *
				frame /						// frames /
				g_WavFromat.Format.nSamplesPerSec +	// (frames / s)
				0.5);							// ľܓH
			TRACE2("C̃CeV         : %I64d (%f~b)\n", default_device_period, default_device_period / 10000.0);

			// xjăI[fBINCAgĐ
			SAFE_RELEASE(g_pAudioClient);
			ret = g_pDevice->Activate(IID_IAudioClient, CLSCTX_ALL, NULL, (void**)&g_pAudioClient);
			if (FAILED(ret)) {
				TRACE0("I[fBINCAgĎ擾s\n");
				return FALSE;
			}

			ret = g_pAudioClient->Initialize(AUDCLNT_SHAREMODE_EXCLUSIVE,
				AUDCLNT_STREAMFLAGS_NOPERSIST | AUDCLNT_STREAMFLAGS_EVENTCALLBACK,
				default_device_period,
				default_device_period,
				(WAVEFORMATEX*)&g_WavFromat,
				NULL);
		}

		if (FAILED(ret)) {
			switch (ret)
			{
			case AUDCLNT_E_NOT_INITIALIZED:					TRACE0("AUDCLNT_E_NOT_INITIALIZED\n");					break;
			case AUDCLNT_E_ALREADY_INITIALIZED:				TRACE0("AUDCLNT_E_ALREADY_INITIALIZED\n");				break;
			case AUDCLNT_E_WRONG_ENDPOINT_TYPE:				TRACE0("AUDCLNT_E_WRONG_ENDPOINT_TYPE\n");				break;
			case AUDCLNT_E_DEVICE_INVALIDATED:				TRACE0("AUDCLNT_E_DEVICE_INVALIDATED\n");				break;
			case AUDCLNT_E_NOT_STOPPED:						TRACE0("AUDCLNT_E_NOT_STOPPED\n");						break;
			case AUDCLNT_E_BUFFER_TOO_LARGE:				TRACE0("AUDCLNT_E_BUFFER_TOO_LARGE\n");				break;
			case AUDCLNT_E_OUT_OF_ORDER:					TRACE0("AUDCLNT_E_OUT_OF_ORDER\n");					break;
			case AUDCLNT_E_UNSUPPORTED_FORMAT:				TRACE0("AUDCLNT_E_UNSUPPORTED_FORMAT\n");				break;
			case AUDCLNT_E_INVALID_SIZE:					TRACE0("AUDCLNT_E_INVALID_SIZE\n");					break;
			case AUDCLNT_E_DEVICE_IN_USE:					TRACE0("AUDCLNT_E_DEVICE_IN_USE\n");					break;
			case AUDCLNT_E_BUFFER_OPERATION_PENDING:		TRACE0("AUDCLNT_E_BUFFER_OPERATION_PENDING\n");		break;
			case AUDCLNT_E_THREAD_NOT_REGISTERED:			TRACE0("AUDCLNT_E_THREAD_NOT_REGISTERED\n");			break;
				//			case AUDCLNT_E_NO_SINGLE_PROCESS:				TRACE0( "AUDCLNT_E_NO_SINGLE_PROCESS\n" );				break;	// VC2010ł͖`H
			case AUDCLNT_E_EXCLUSIVE_MODE_NOT_ALLOWED:		TRACE0("AUDCLNT_E_EXCLUSIVE_MODE_NOT_ALLOWED\n");		break;
			case AUDCLNT_E_ENDPOINT_CREATE_FAILED:			TRACE0("AUDCLNT_E_ENDPOINT_CREATE_FAILED\n");			break;
			case AUDCLNT_E_SERVICE_NOT_RUNNING:				TRACE0("AUDCLNT_E_SERVICE_NOT_RUNNING\n");				break;
			case AUDCLNT_E_EVENTHANDLE_NOT_EXPECTED:		TRACE0("AUDCLNT_E_EVENTHANDLE_NOT_EXPECTED\n");		break;
			case AUDCLNT_E_EXCLUSIVE_MODE_ONLY:				TRACE0("AUDCLNT_E_EXCLUSIVE_MODE_ONLY\n");				break;
			case AUDCLNT_E_BUFDURATION_PERIOD_NOT_EQUAL:	TRACE0("AUDCLNT_E_BUFDURATION_PERIOD_NOT_EQUAL\n");	break;
			case AUDCLNT_E_EVENTHANDLE_NOT_SET:				TRACE0("AUDCLNT_E_EVENTHANDLE_NOT_SET\n");				break;
			case AUDCLNT_E_INCORRECT_BUFFER_SIZE:			TRACE0("AUDCLNT_E_INCORRECT_BUFFER_SIZE\n");			break;
			case AUDCLNT_E_BUFFER_SIZE_ERROR:				TRACE0("AUDCLNT_E_BUFFER_SIZE_ERROR\n");				break;
			case AUDCLNT_E_CPUUSAGE_EXCEEDED:				TRACE0("AUDCLNT_E_CPUUSAGE_EXCEEDED\n");				break;
			default:										TRACE0("UNKNOWN\n");									break;
			}
			return FALSE;
		}
		// _[̎擾
		ret = g_pAudioClient->GetService(IID_IAudioRenderClient, (void**)&g_pRenderClient);
		if (FAILED(ret)) {
			TRACE0("_[擾G[\n");
			return FALSE;
		}
	}
	return true;
}

int CPcm::GetDevices(CString* pstrDevices, EDataFlow mode)
{
	HRESULT ret;
	IMMDeviceEnumerator* pDeviceEnumerator = NULL;		// }`fBAfoCX񋓃C^[tF[X
	IMMDeviceCollection* pDevices = NULL;


	ret = CoInitializeEx(0, COINIT_MULTITHREADED);

	// }`fBAfoCX񋓎q
	ret = CoCreateInstance(CLSID_MMDeviceEnumerator, NULL, CLSCTX_INPROC_SERVER, IID_IMMDeviceEnumerator, (void**)&pDeviceEnumerator);
	if (FAILED(ret)) {
		TRACE0("CLSID_MMDeviceEnumeratorG[\n");
		return 0;
	}

	// foCX̎擾
	ret = pDeviceEnumerator->EnumAudioEndpoints(mode, DEVICE_STATE_ACTIVE, (IMMDeviceCollection**)&pDevices);
	if (FAILED(ret)) {
		TRACE0("EnumAudioEndpointsG[\n");
		return 0;
	}
	UINT  cnt;
	ret = pDevices->GetCount(&cnt);
	if (FAILED(ret)) {
		TRACE0("GetCountG[\n");
		return 0;
	}
	PROPVARIANT vName;
	IMMDevice* pEndpoint;
	IPropertyStore* pProperties;

	UINT  i;
	for (i = 0; i < cnt; i++)
	{
		pDevices->Item(i, &pEndpoint);
		pEndpoint->OpenPropertyStore(STGM_READ, &pProperties);
		PropVariantInit(&vName);
		pProperties->GetValue(PKEY_Device_FriendlyName, &vName);
		CString str = vName.bstrVal;
		*(pstrDevices + i) = str;
	}
	SAFE_RELEASE(pDevices);
	SAFE_RELEASE(pDeviceEnumerator);
	CoUninitialize();
	return cnt;
}



BOOL CPcm::OpenWavFile(const char* lpszfile)
{
	CFile file;
	CString str = GetMyFolderName() + lpszfile;
	if (file.Open(str, CFile::modeRead) == FALSE)
	{
		return FALSE;
	}
	file.Read(&g_WavHeader, sizeof(WAVHEADER));
	if (_strnicmp(g_WavHeader.mRiff, "RIFF", 4) != 0) {
		TRACE0("RIFFtH[}bgG[\n");
		return FALSE;
	}
	if (_strnicmp(g_WavHeader.mWave, "WAVE", 4) != 0) {
		TRACE0("WAV`NȂ\n");
		return FALSE;
	}
	if (_strnicmp(g_WavHeader.mFmt, "fmt ", 4) != 0) {
		TRACE0("tH[}bg`NȂ\n");
		return FALSE;
	}
	// data`NT
	DATACHUNC data;
	file.Read(&data, sizeof(DATACHUNC));

	// data`NȂ甲
	if (_strnicmp(data.mData, "data", 4) != 0)
	{
		TRACE0("f[^`NȂ\n");
		return FALSE;
	}

	// f[^TCY̎擾
	g_dwDataSize = data.dwSize;
	if (g_pbyData != NULL)
	{
		delete[] g_pbyData;
	}
	g_pbyData = new BYTE[g_dwDataSize];

	if (!g_pbyData) {
		TRACE0("mۃG[\n");
		return FALSE;
	}
	file.Read(g_pbyData, g_dwDataSize);
	file.Close();

    return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
// ĐXbh
//////////////////////////////////////////////////////////////////////////////////////
DWORD CALLBACK PlayThread(LPVOID param)
{
	// Xbh̗Dxグ
	CWnd* pWin = (CWnd * )param;
	DWORD dwTaskIndex = 0;
	HANDLE mmcss = AvSetMmThreadCharacteristicsW(L"Pro Audio", &dwTaskIndex);
	if (!mmcss) {
		TRACE0("AvSetMmThreadCharacteristicsG[\n");
	}
	
	while (m_bThreadLoop) {
		// ̃obt@擾KvɂȂ܂őҋ@
		DWORD retval = WaitForSingleObject(g_hEvent, 2000);
		if (retval != WAIT_OBJECT_0) {
			g_pAudioClient->Stop();
			break;
		}

		// Kvȃt[擾
		UINT32 frame_size;
		HRESULT ret = g_pAudioClient->GetBufferSize(&frame_size);
		// t[obt@TCYZo
		int buf_size = frame_size * m_nFrameSize;

		// o̓obt@̃|C^擾
		LPBYTE dst;
		ret = g_pRenderClient->GetBuffer(frame_size, &dst);
		if (SUCCEEDED(ret)) {
			// \[Xobt@̃|C^擾
			LPBYTE src = GetBuffer();
			int size =GetBufferSize();

			if (m_nCurrentIndex >= size)
			{
				g_pAudioClient->Stop();
				g_pRenderClient->ReleaseBuffer(frame_size, 0);
				m_bThreadLoop = FALSE;
				break;
			}
			// ݂̈ʒu玟ɕKvȃobt@TCYZƂWAVobt@̃TCY𒴂邩
			if (m_nCurrentIndex + buf_size > size) {
				// WAVobt@TCY猻݂̃J[\ʒûŌ܂ł̃obt@TCY
				int last_size = size - m_nCurrentIndex;
				memset(&dst[0], 0, buf_size);
				// ݂̈ʒuŌ܂ł̃obt@o̓obt@̐擪ɃRs[
				memcpy(&dst[0], &src[m_nCurrentIndex], last_size);

				// CfbNXf[^ɂčĐIɂ
				m_nCurrentIndex = size;

			}
			else {
				// WAVobt@݂̌̃CfbNXo̓obt@ɎwTCYRs[
				memcpy(&dst[0], &src[m_nCurrentIndex], buf_size);

				m_nCurrentIndex += buf_size;
			}

			// obt@J
			g_pRenderClient->ReleaseBuffer(frame_size, 0);
		}

	}
	
	// Avrt֐ŃXbh̗DxグĂȂ猳ɖ߂
	if (mmcss) {
		AvRevertMmThreadCharacteristics(mmcss);
	}

	ReleaseInterface();
	pWin->SendMessage(WM_PLAYED, 0, NULL);
	return 0;
}

void CPcm::PlayTop()
{
	CoInitializeEx(0, COINIT_MULTITHREADED);
	m_nCurrentIndex = 0;
}


BOOL CPcm::CreatePlayThread(CWnd* pWin)
{
	HRESULT ret;

	// Cxg
	g_hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	if (!g_hEvent) {
		return FALSE;
	}

	// Cxg̃Zbg
	ret = g_pAudioClient->SetEventHandle(g_hEvent);
	if (FAILED(ret)) {
		return FALSE;
	}
	// WASAPI擾
	UINT32 frame = 0;
	ret = g_pAudioClient->GetBufferSize(&frame);
	UINT32 size = frame * m_nFrameSize;
	
	// [NAăCxgZbg
	LPBYTE pData;
	ret = g_pRenderClient->GetBuffer(frame, &pData);
	if (SUCCEEDED(ret)) {
		ZeroMemory(pData, size);
		g_pRenderClient->ReleaseBuffer(frame, 0);
	}

	// Xbh[vtO𗧂Ă
	m_bThreadLoop = TRUE;

	// ĐXbhN
	DWORD dwThread;
	m_hThread = ::CreateThread(NULL, 0, PlayThread, (LPVOID)pWin, 0, &dwThread);
	if (!m_hThread) {
		// s
		return FALSE;
	}

	// ĐJn
	g_pAudioClient->Start();

	return TRUE;
}




