﻿
// MfcSoundDlg.cpp : 実装ファイル
//

#include "pch.h"
#include "framework.h"
#include "MfcSound.h"
#include "MfcSoundDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

extern void ReleaseInterface();
// アプリケーションのバージョン情報に使われる CAboutDlg ダイアログ

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ダイアログ データ
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV サポート

// 実装
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMfcSoundDlg ダイアログ



CMfcSoundDlg::CMfcSoundDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCSOUND_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	HRESULT ret = CoInitializeEx(0, COINIT_MULTITHREADED);

}
CMfcSoundDlg::~CMfcSoundDlg()
{
	// COMの終了
	CoUninitialize();
}

void CMfcSoundDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMfcSoundDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PLAY, &CMfcSoundDlg::OnBnClickedPlay)
	ON_BN_CLICKED(IDC_REC, &CMfcSoundDlg::OnBnClickedRec)
	ON_MESSAGE(WM_PLAYED, &CMfcSoundDlg::OnPlayed)
END_MESSAGE_MAP()


// CMfcSoundDlg メッセージ ハンドラー

BOOL CMfcSoundDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// "バージョン情報..." メニューをシステム メニューに追加します。

	// IDM_ABOUTBOX は、システム コマンドの範囲内になければなりません。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// このダイアログのアイコンを設定します。アプリケーションのメイン ウィンドウがダイアログでない場合、
	//  Framework は、この設定を自動的に行います。
	SetIcon(m_hIcon, TRUE);			// 大きいアイコンの設定
	SetIcon(m_hIcon, FALSE);		// 小さいアイコンの設定

	// TODO: 初期化をここに追加します。
	CListBox* pDevices = (CListBox*)GetDlgItem(IDC_PLAYING);
	pDevices->ResetContent();
	CString strDevices[MAX_DEVICE];
	int size = m_Pcm.GetDevices(strDevices, eRender);
	int i;
	for (i = 0; i < size; i++)
	{
		pDevices->AddString(strDevices[i]);
	}

	pDevices = (CListBox*)GetDlgItem(IDC_RECORDING);
	pDevices->ResetContent();
	size = m_Pcm.GetDevices(strDevices, eCapture);
	for (i = 0; i < size; i++)
	{
		pDevices->AddString(strDevices[i]);
	}

	return TRUE;  // フォーカスをコントロールに設定した場合を除き、TRUE を返します。
}

void CMfcSoundDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ダイアログに最小化ボタンを追加する場合、アイコンを描画するための
//  下のコードが必要です。ドキュメント/ビュー モデルを使う MFC アプリケーションの場合、
//  これは、Framework によって自動的に設定されます。

void CMfcSoundDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 描画のデバイス コンテキスト

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// クライアントの四角形領域内の中央
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// アイコンの描画
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ユーザーが最小化したウィンドウをドラッグしているときに表示するカーソルを取得するために、
//  システムがこの関数を呼び出します。
HCURSOR CMfcSoundDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CMfcSoundDlg::OnBnClickedPlay()
{
	//wavファイルの読み込み
	if(m_Pcm.OpenWavFile("restra.wav")== FALSE)
	{ 
		AfxMessageBox(_T("wavファイルが読み込めません！"));
		return;
	}

	m_Pcm.PlayTop();
	// COMの初期化
	CoInitialize(NULL);
	if (m_Pcm.GetDefaultDevice() == FALSE)
	{
		ReleaseInterface();
		return;
	}
	if (m_Pcm.IsFormat() == FALSE)
	{
		ReleaseInterface();
		return;
	}
	if (m_Pcm.SetLatency() == FALSE)
	{
		ReleaseInterface();
		return;
	}
	if (m_Pcm.CreatePlayThread(this) == FALSE)
	{
		ReleaseInterface();
		return;
	}
	CButton* pBtn = (CButton*)GetDlgItem(IDC_PLAY);
	pBtn->EnableWindow(FALSE);
	// WASAPI初期化
	//if (!m_Pcm.initWASAPI()) {			// 0ならデフォルトデバイスピリオドを使用
		// エラーなら終了する
		//AfxMessageBox(_T( "WASAPI初期化失敗"));
		////ExitWASAPI();
		//CoUninitialize();
		//return;
	//}
}


void CMfcSoundDlg::OnBnClickedRec()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
}

LRESULT  CMfcSoundDlg::OnPlayed(WPARAM wParam, LPARAM lParam)
{
	CButton* pBtn = (CButton*)GetDlgItem(IDC_PLAY);
	pBtn->EnableWindow(TRUE);
	return 0;
}
