package com.example.ble03;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import java.util.ArrayList;

public class MainActivity extends AppCompatActivity {
    private BluetoothDevice device;
    private BluetoothAdapter adapter;
    private BluetoothLeScanner scanner;
    private TextView textView;
    private MyScancallback scancallback;
    private static final int REQUEST_MULTI_PERMISSIONS = 101;
    private boolean permission31 = true;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        textView = findViewById(R.id.text_view);
        textView.setText("");


        if (!getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)) {
            textView.setText("BLEをサポートしていません！");
            return;
        }
        //BluetoothManager
        BluetoothManager manager = (BluetoothManager)getSystemService(Context.BLUETOOTH_SERVICE);

        //adapter
        adapter = manager.getAdapter();
        if( adapter == null || !adapter.isEnabled() ){
            textView.setText("BLEが許可されていません！");
            return;
        }
        //BluetoothLeScanner
        scanner = adapter.getBluetoothLeScanner();
        //ScanFilter

        //scanFilterList

        //ScanSettings

        //checkSelfPermission
        checkPermissions();
        scancallback = new MyScancallback();
        scanner.startScan(scancallback);

    }

    private void checkPermissions() {
        ArrayList<String> requestPermissions = new ArrayList<>();
        //Bluetooth
        if(Build.VERSION.SDK_INT > 30) {
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_CONNECT)
                    != PackageManager.PERMISSION_GRANTED) {
                requestPermissions.add(Manifest.permission.BLUETOOTH_CONNECT);
            }
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_SCAN)
                    != PackageManager.PERMISSION_GRANTED) {
                requestPermissions.add(Manifest.permission.BLUETOOTH_SCAN);
            }
        }
        if (!requestPermissions.isEmpty()) {
            ActivityCompat.requestPermissions(this, requestPermissions.toArray(new String[0]), REQUEST_MULTI_PERMISSIONS);
        }
    }

    //ScanCallback
    class MyScancallback extends ScanCallback {
        @Override
        public void onScanResult(int callbackType, ScanResult result) {
            Log.d("scanResult","start");
            if( result.getDevice() == null ) return;
            textView.append(result.getDevice().getAddress()  + " - " +
                    result.getDevice().getName() + "\n");
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == REQUEST_MULTI_PERMISSIONS) {
            if (grantResults.length > 0) {
                for (int i = 0; i < permissions.length; i++) {
                    switch (permissions[i]) {
                        case Manifest.permission.BLUETOOTH_CONNECT:
                        case Manifest.permission.BLUETOOTH_SCAN:
                            if (grantResults[i] != PackageManager.PERMISSION_GRANTED) {
                                permission31 = false;
                            }
                            break;
                        default:
                    }
                }
            }
        }
    }
}